xquery version "1.0";

declare namespace request="http://exist-db.org/xquery/request";
declare namespace response="http://exist-db.org/xquery/response";

declare function local:traverseParts($consist_of as element()*) as element()* {
  for $item in $consist_of/parts
  let $parts := document("/db/inventory/parts.xml")/parts_list/parts[@id = $item/@id]
  return
     if ($parts/consist_of/parts)
     then <parts id="{xs:string($parts/@id)}" name="{$parts/name/text()}">
         {local:traverseParts($parts/consist_of)}
       </parts>
     else <part id="{xs:string($parts/@id)}" name="{$parts/name/text()}"/>
};

response:set-header("Content-Type", "text/xml"),
let $id := request:get-parameter("id", "")
let $product := document("/db/inventory/products.xml")/products/product[@id = $id]
return
<product id="{xs:string($product/@id)}" name="{$product/name/text()}">
  {local:traverseParts($product/consist_of)}
</product>
