/**
 * http://extjs.com/forum/showthread.php?t=3987
 * Animal氏作成のスクリプトを一部修正しました。
 */
function createXmlTree(el, url, tree, parms) {
    var p = new Ext.data.HttpProxy({url:url});
    p.on("loadexception", function(o, response, e) {
        if (e) throw e;
    });
    p.load(parms, {
        read: function(response) {
            var doc = response.responseXML;
            tree.setRootNode(treeNodeFromXml(doc.documentElement || doc));
        }
    }, tree.render, tree);
}
 
/**
 *   XMLノードからツリーノードを作成します
*/
function treeNodeFromXml(XmlEl) {
    //属性を配列としてまとめます
    var t = [];
    Ext.each(XmlEl.attributes, function(a) {
        t = t.concat(a.nodeValue);
    });
    //複数の属性を「/」で連結します
    var ret = t.join("/");
    if (ret.replace(/\s/g,'').length == 0) {
        return null;
    }
    //属性を値としたツリーノードを作成します
    var result = new Ext.tree.TreeNode({
        text : ret
    });
    //要素ごとに再帰的に処理をしていきます
    if (XmlEl.nodeType == 1) {
        Ext.each(XmlEl.childNodes, function(el) {
            if ((el.nodeType == 1)) {
                var c = treeNodeFromXml(el);
                if (c) {
                    result.appendChild(c);
                }
            }
        });
    }
    return result;
}